# Simple License API Server (PHP + SQLite)

A drop-in PHP endpoint you can host on any cPanel/shared hosting to validate and manage license keys for your **Meta CAPI Pro** plugin (or any product).

## Requirements
- PHP 7.4+
- SQLite (PDO SQLite enabled)

## Setup
1. Upload all files to a folder on your server, e.g. `/license-api/`
2. Edit `config.php` and change `ADMIN_SECRET` to a strong secret string.
3. Done. The server auto-creates `license.db` on first request.

## Endpoints (POST)
- `action=generate` (admin only)  
  Body: `admin_secret`, `plan`, `max_activations`, `expires_at (YYYY-MM-DD or empty)`, `notes (optional)`  
  Response: `{status: 'ok', data: {license_key}}`

- `action=list` (admin only)  
  Body: `admin_secret`  
  Response: list of licenses with activation counts

- `action=validate`  
  Body: `license_key`, `site`, `plugin`, `version`  
  Response: `status: valid|invalid|expired|limit`

- `action=activate`  
  Body: `license_key`, `site`, `plugin`, `version`  
  Response: `{status: 'ok'}` if activated

- `action=deactivate`  
  Body: `license_key`, `site`  
  Response: `{status: 'ok'}`

## Curl Examples
```bash
# Generate a license (admin)
curl -X POST https://yourdomain.com/license-api/api.php \
  -d "action=generate&admin_secret=YOUR_SECRET&plan=pro&max_activations=3&expires_at=2026-12-31&notes=Client+ABC"

# List licenses (admin)
curl -X POST https://yourdomain.com/license-api/api.php \
  -d "action=list&admin_secret=YOUR_SECRET"

# Activate on a site
curl -X POST https://yourdomain.com/license-api/api.php \
  -d "action=activate&license_key=XXXX-XXXX-XXXX-XXXX&site=https://client.com&plugin=meta-capi-pro&version=1.0.0"

# Validate from plugin (server checks expiry/limit)
curl -X POST https://yourdomain.com/license-api/api.php \
  -d "action=validate&license_key=XXXX-XXXX-XXXX-XXXX&site=https://client.com&plugin=meta-capi-pro&version=1.0.0"

# Deactivate a site
curl -X POST https://yourdomain.com/license-api/api.php \
  -d "action=deactivate&license_key=XXXX-XXXX-XXXX-XXXX&site=https://client.com"
```

## Security Notes
- Keep `ADMIN_SECRET` private.
- Serve over HTTPS.
- For extra control, protect the folder with HTTP Auth or IP allowlist.
